package jamezo97.clonecraft.dna;

import jamezo97.clonecraft.entity.EntityModifiable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;

public class GeneSpeedDecrease extends Gene{

	public GeneSpeedDecrease(int id) {
		super(id);
	}

	@Override
	public String getName() {
		return "Speed Decrease";
	}

	@Override
	public int getMaxAmount() {
		return 2;
	}

	@Override
	public String getStringValue(int amount) {
		return amount*100 + "% Speed Decrease";
	}
	
	@Override
	public void onUpdate(EntityLivingBase entity, IModifiable mod, int level) {
		if(!entity.isPotionActive(Potion.moveSlowdown.id)){
			entity.addPotionEffect(new PotionEffect(Potion.moveSlowdown.id, Integer.MAX_VALUE, level));
		}
	}

	@Override
	public int getColour() {
		return 0xff8139b8;
	}

	@Override
	public void addGeneEffect(EntityLivingBase entity, int level) {
		entity.addPotionEffect(new PotionEffect(Potion.moveSlowdown.id, Integer.MAX_VALUE, level));
	}

	@Override
	public Class[] getEntityClassesWithGene() {
		return new Class[]{EntityZombie.class, EntitySlime.class};
	}


}
